var samplePageObj = {
  // 샘플 타이틀
  title: 'MathJax 연동 예제',
  subtitle: 'MathJax 연동 예제입니다.',
  // 샘플 설명
  desc: '외부라이브러리를 연동하는 예제입니다. MathJax는 \\(\\rm\\TeX\\), \\(\\rm\\LaTeX\\) 등, 수식 (\\(x = 2y\\)) 기호를 렌더링해주는 라이브러리입니다.',

  externalScript: ['https://cdnjs.cloudflare.com/ajax/libs/mathjax/2.7.5/latest.js?config=TeX-MML-AM_CHTML'],

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 2,
      HeaderMerge: 0
    },
    Def: {
      Row: {
        CanFormula: true
      }
    },
    LeftCols: [
      {
        Type: 'Int',
        Width: 50,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '수식 이름',
        Type: 'Text',
        Name: 'ExpName',
        Width: 150,
        Align: 'Center',
        CanEdit: 1
      },
      {
        Header: '문법',
        Type: 'Html',
        Name: 'Grammer',
        MinWidth: 100,
        Align: 'Center',
        CanEdit: 1,
        RelWidth: 1,
        HtmlPrefix: '<pre style=\'white-space: pre-wrap;\'>',
        HtmlPostfix: '</pre>'
      },
      {
        Header: '수식 기호 (문법 기준)',
        Type: 'Text',
        Name: 'Expression1',
        MinWidth: 100,
        Align: 'Center',
        CanEdit: 0,
        Formula: 'Row[\'Grammer\']',
        TextColor: 'black',
        TextStyle: 0,
        RelWidth: 1
      },
      {
        Header: '수식 편집',
        Type: 'Text',
        Name: 'Expression2',
        MinWidth: 100,
        Align: 'Center',
        CanEdit: 1,
        TextColor: 'black',
        TextStyle: 0,
        RelWidth: 1
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '<span></span>',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },

  // 버튼 클릭시 기능 로직
  action: function () {

  },

  // event구문
  event: {
    onBeforeChange: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      if (evtParam.col === 'Grammer' || evtParam.col === 'Expression2') {
        // 셀 값 편집과 상관없이 수식 렌더링
        setTimeout(function () {
          if (MathJax && MathJax.Hub) {
            MathJax.Hub.Queue([
              'Typeset',
              MathJax.Hub
            ]);
          }
        }, 50);
      }
    },
    onSearchFinish: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      // 시트 생성 이후 데이터 조회 및 재조회 후 수식 렌더링
      if (MathJax && MathJax.Hub) {
        MathJax.Hub.Queue([
          'Typeset',
          MathJax.Hub
        ]);
      }
    },
    onRenderFirstFinish: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      // 시트 생성 이후 수식 렌더링
      setTimeout(function () {
        if (MathJax && MathJax.Hub) {
          MathJax.Hub.Queue([
            'Typeset',
            MathJax.Hub
          ]);
        }
      }, 50);
    },
    onRenderFinish: function () {
      // 시트 rerendering 이후 수식 렌더링
      setTimeout(function () {
        if (MathJax && MathJax.Hub) {
          MathJax.Hub.Queue([
            'Typeset',
            MathJax.Hub
          ]);
        }
      }, 50);
    },
    onAfterSort: function () {
      // 정렬 이후 수식 렌더링
      if (MathJax && MathJax.Hub) {
        MathJax.Hub.Queue([
          'Typeset',
          MathJax.Hub
        ]);
      }
    },
    onAfterFilter: function () {
      // 필터링 이후 수식 렌더링
      if (MathJax && MathJax.Hub) {
        MathJax.Hub.Queue([
          'Typeset',
          MathJax.Hub
        ]);
      }
    }
  },

  // style 추가
  internalStyles: 'a{text-decoration:none;color:#4444FF;} .SheetMain span { color: inherit; font-weight: inherit;} .SheetMain .mjx-chtml * { font-size: 100%; line-height: 0; }',

  // data
  data: [
    {
      ExpName: '제곱',
      Grammer: '\\( a^2 \\)',
      Expression2: '\\( a^2 \\)'
    },
    {
      ExpName: '행렬',
      Grammer: '\\begin{pmatrix} 1 & a_1 & a_1^2 & \\cdots & a_1^n \\\\ 1 & a_2 & a_2^2 & \\cdots & a_2^n \\\\ \\vdots  & \\vdots& \\vdots & \\ddots & \\vdots \\\\ 1 & a_m & a_m^2 & \\cdots & a_m^n \\end{pmatrix}',
      Expression2: '\\begin{pmatrix} 1 & a_1 & a_1^2 & \\cdots & a_1^n \\\\ 1 & a_2 & a_2^2 & \\cdots & a_2^n \\\\ \\vdots  & \\vdots& \\vdots & \\ddots & \\vdots \\\\ 1 & a_m & a_m^2 & \\cdots & a_m^n \\end{pmatrix}'
    },
    {
      ExpName: '나눗셈',
      Grammer: '$$ \\require{enclose} \\begin{array}{r}13 \\\\[-3pt] 4 \\enclose{longdiv}{52} \\\\[-3pt]\\underline{4}\\phantom{2} \\\\[-3pt] 12\\\\[-3pt]\\underline{12} \\end{array} $$',
      Expression2: '$$ \\require{enclose} \\begin{array}{r}13 \\\\[-3pt] 4 \\enclose{longdiv}{52} \\\\[-3pt]\\underline{4}\\phantom{2} \\\\[-3pt] 12\\\\[-3pt]\\underline{12} \\end{array} $$'
    },
    {
      ExpName: '평균',
      Grammer: '$$ \\bar{x} = \\sum\\limits_{i=1}^n \\frac{x_i}{n} $$',
      Expression2: '$$ \\bar{x} = \\sum\\limits_{i=1}^n \\frac{x_i}{n} $$'
    },
    {
      ExpName: '표준편차',
      Grammer: '$$ {S} = \\sqrt{S^2} = \\sqrt{\\frac{1}{n-1} \\sum\\limits_{i=1}^{n}(x_i - \\bar{x})^{2}} $$',
      Expression2: '$$ {S} = \\sqrt{S^2} = \\sqrt{\\frac{1}{n-1} \\sum\\limits_{i=1}^{n}(x_i - \\bar{x})^{2}} $$'
    },
    {
      ExpName: '경우 나누기',
      Grammer: '$$ f(n)= \\begin{cases} n/2, & \\mbox{if }n\\mbox{ is even} \\\\ 3n+1, & \\mbox{if }n\\mbox{ is odd} \\end{cases} $$',
      Expression2: '$$ f(n)= \\begin{cases} n/2, & \\mbox{if }n\\mbox{ is even} \\\\ 3n+1, & \\mbox{if }n\\mbox{ is odd} \\end{cases} $$'
    },
    {
      ExpName: '방정식',
      Grammer: '$$ \\begin{matrix} f(n+1) &=& (n+1)^2 \\\\ &=& n^2 + 2n + 1 \\end{matrix} $$',
      Expression2: '$$ \\begin{matrix} f(n+1) &=& (n+1)^2 \\\\ &=& n^2 + 2n + 1 \\end{matrix} $$'
    },
    {
      ExpName: '근의 공식 (2)',
      Grammer: '$$ x = {-b \\pm \\sqrt{b^2-4ac} \\over 2a} $$',
      Expression2: '$$ x = {-b \\pm \\sqrt{b^2-4ac} \\over 2a} $$'
    },
    {
      ExpName: '삼각함수',
      Grammer: '$$ y = \\sin{x} $$',
      Expression2: '$$ y = \\sin{x} $$'
    },
    {
      ExpName: '로그함수',
      Grammer: '$$ y = \\log_{10} {x} $$',
      Expression2: '$$ y = \\log_{10} {x} $$'
    },
    {
      ExpName: '미분',
      Grammer: '$$ x\' $$',
      Expression2: '$$ x\' $$'
    },
    {
      ExpName: '적분',
      Grammer: '$$ \\int_{-N}^{N} e^x\\, dx $$',
      Expression2: '$$ \\int_{-N}^{N} e^x\\, dx $$'
    },
    {
      ExpName: '선적분',
      Grammer: '$$ \\oint_{C} x^3\\, dx + 4y^2\\, dy $$',
      Expression2: '$$ \\oint_{C} x^3\\, dx + 4y^2\\, dy $$'
    },
    {
      ExpName: '시그마',
      Grammer: '$$ \\sum_{k=1}^N k^2 $$',
      Expression2: '$$ \\sum_{k=1}^N k^2 $$'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
